//
//  BIAttributedTextField.h
//  BIViews
//
//  Created by Kevin Hiscott on 16/06/08.
//  Copyright 2008 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface MCAttributedTextField : NSTextField {
    NSMutableDictionary *attributes;
	NSMutableDictionary *altAttributes;
	BOOL drawAlternate;
}

- (NSMutableDictionary *)attributes;
- (void)setAttributes:(NSMutableDictionary *)anAttributes;
- (NSMutableDictionary *)altAttributes;
- (void)setAltAttributes:(NSMutableDictionary *)anAltAttributes;
- (BOOL)drawAlternate;
- (void)setDrawAlternate:(BOOL)flag;

- (void)setAttribute:(id)anAttribute forKey:(id)aKey;
- (void)removeAttributeForKey:(id)aKey;

- (void)setAltAttribute:(id)anAttribute forKey:(id)aKey;
- (void)removeAltAttributeForKey:(id)aKey;

+ (NSMutableDictionary *)defaultAttributes;
- (void)configure;

@end
